import { HostListener, Component, OnInit, Inject } from '@angular/core'
import { ErrorService } from '../../core/error-messages/error.service'
import { SearchApiService } from '../../core/search/search-api.service'
import { MainContentService } from '../maincontent/maincontent.service'
import { MainContent } from '../maincontent/maincontent'
import { Product } from '../maincontent/product'

@Component({
  selector: 'app-homepage',
  templateUrl: './homepage.component.html',
  styleUrls: ['./homepage.component.css']
})
export class HomepageComponent implements OnInit {
  public quickContactData: Array<string> = ['','','','','','','','','']
  public quickUpdatesData: Array<string> = ['','','','','']
  public quickNewsData: Array<string> = ['','','']
  searchBoxDataSource: string
  maincontentService: MainContentService
  maincontent: MainContent
  products: Array<Product>

  constructor(private error: ErrorService,
    public searchApiService: SearchApiService,
    private mcService: MainContentService) {
    this.searchBoxDataSource = 'contacts'
    this.maincontentService = mcService
  }

  async ngOnInit() {
    // TODO replace with data source
    // this.searchApiService.sample({ datasource: 'contacts', count: 9 })
    //   .subscribe(results => this.quickContactData = results)
    // this.searchApiService.sample({ datasource: 'updates', count: 5 })
    //   .subscribe(results => this.quickUpdatesData = results)
    // this.searchApiService.sample({ datasource: 'news', count: 3 })
    //  .subscribe(results => this.quickNewsData = results)

    this.maincontentService.getContent().subscribe(this.contentUpdate.bind(this))

    calLoad() // TODO take out and replace with real one
  }

  errorPopup() {
    this.error.setErrorCode("", "stack trace error: very long error trace and detailed information.!!!!!!!!!!!!!!!");
  }

  contentUpdate(data: any) {
    this.maincontent = data

    let prod: Array<Product> = []
    for (let i = 0; i < this.maincontent.product.length; i++) {
      if (this.maincontent.product[i].showbox) {
        prod.push(this.maincontent.product[i])
      }
    }
    this.products = prod
  }

}

function calLoad() {

  // Start calendar
  let c = new Cal("divCal");
  c.showcurr();

  // Bind next and previous button clicks
  let btnnext = document.getElementById('btnNext')
  if (btnnext) {
    btnnext.onclick = function() {
      c.nextMonth();
    };
  }


  let btnprev = document.getElementById('btnPrev')
  if (btnprev) {
    btnprev.onclick = function() {
      c.previousMonth();
    };
  }

}

let Cal = function(divId) {

  // Store div id
  this.divId = divId;

  // Days of week, starting on Sunday
  this.DaysOfWeek = [
    'Sun',
    'Mon',
    'Tue',
    'Wed',
    'Thu',
    'Fri',
    'Sat'
  ];

  // Months, stating on January
  this.Months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

  // Set the current month, year
  let d = new Date();

  this.currMonth = d.getMonth();
  this.currYear = d.getFullYear();
  this.currDay = d.getDate();

};

// Goes to next month
Cal.prototype.nextMonth = function() {
  if (this.currMonth === 11) {
    this.currMonth = 0;
    this.currYear = this.currYear + 1;
  } else {
    this.currMonth = this.currMonth + 1;
  }
  this.showcurr();
};

// Goes to previous month
Cal.prototype.previousMonth = function() {
  if (this.currMonth === 0) {
    this.currMonth = 11;
    this.currYear = this.currYear - 1;
  } else {
    this.currMonth = this.currMonth - 1;
  }
  this.showcurr();
};

// Show current month
Cal.prototype.showcurr = function() {
  this.showMonth(this.currYear, this.currMonth);
};

// Show month (year, month)
Cal.prototype.showMonth = function(y, m) {

  let d = new Date()
    // First day of the week in the selected month
    , firstDayOfMonth = new Date(y, m, 1).getDay()
    // Last day of the selected month
    , lastDateOfMonth = new Date(y, m + 1, 0).getDate()
    // Last day of the previous month
    , lastDayOfLastMonth = m === 0 ? new Date(y - 1, 11, 0).getDate() : new Date(y, m, 0).getDate();


  let html = '<table>';

  // Write selected month and year
  html += '<thead><tr>';
  html += '<td colspan="7">' + this.Months[m] + ' ' + y + '</td>';
  html += '</tr></thead>';


  // Write the header of the days of the week
  html += '<tr class="days">';
  for (let i = 0; i < this.DaysOfWeek.length; i++) {
    html += '<td>' + this.DaysOfWeek[i] + '</td>';
  }
  html += '</tr>';

  // Write the days
  let i = 1;
  do {

    let dow = new Date(y, m, i).getDay();

    // If Sunday, start new row
    if (dow === 0) {
      html += '<tr>';
    } else if (i === 1) {
      // If not Sunday but first day of the month
      // it will write the last days from the previous month
      html += '<tr>';
      let k = lastDayOfLastMonth - firstDayOfMonth + 1;
      for (let j = 0; j < firstDayOfMonth; j++) {
        // html += '<td class="not-current">' + k + '</td>';
        html += '<td class="not-current"> </td>';
        k++;
      }
    }

    // Write the current day in the loop
    let chk = new Date();
    let chkY = chk.getFullYear();
    let chkM = chk.getMonth();
    if (chkY === this.currYear && chkM === this.currMonth && i === this.currDay) {
      html += '<td class="today">' + i + '</td>';
    } else {
      html += '<td class="normal">' + i + '</td>';
    }
    // If Saturday, closes the row
    if (dow === 6) {
      html += '</tr>';
    } else if (i === lastDateOfMonth) {
      // If not Saturday, but last day of the selected month
      // it will write the next few days from the next month
      let k = 1;
      for (dow; dow < 6; dow++) {
        // html += '<td class="not-current">' + k + '</td>';
        html += '<td class="not-current"> </td>';
        k++;
      }
    }

    i++;
  } while (i <= lastDateOfMonth);

  // Closes table
  html += '</table>';

  // Write HTML to the div
  let divid = document.getElementById(this.divId)
  if (divid) {
    divid.innerHTML = html;
  }
};
